/*
 * Decompiled with CFR 0.152.
 */
package de.thexxturboxx.blockhelper.integration.nei;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import de.thexxturboxx.blockhelper.api.BlockHelperModSupport;
import de.thexxturboxx.blockhelper.integration.nei.NEIIntegration;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;

public final class ModIdentifier {
    public static final String MINECRAFT = "Minecraft";
    private static final Map objectToMod = new HashMap();
    private static Set modInfos;

    private ModIdentifier() {
        throw new UnsupportedOperationException();
    }

    public static void load() {
        try {
            Class.forName("codechicken.nei.API");
            Class.forName("codechicken.nei.IHandleTooltip");
            NEIIntegration.register();
            mod_BlockHelper.LOGGER.info("NotEnoughItems loaded, Item Tooltips enabled.");
        }
        catch (Throwable t) {
            mod_BlockHelper.LOGGER.warning("NotEnoughItems not loaded, Item Tooltips disabled.");
        }
    }

    public static void firstTick() {
        modInfos = new HashSet();
        String minecraftUri = new File("bin/minecraft.jar").getAbsoluteFile().toString();
        try {
            minecraftUri = ModIdentifier.formatURI(Minecraft.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        modInfos.add(new ModInfo(minecraftUri, MINECRAFT));
        try {
            block10: for (ModContainer container : Loader.getModList()) {
                try {
                    File source = container.getSource();
                    if (!source.isFile()) continue;
                    String uri = ModIdentifier.formatURI(source.toURI());
                    for (ModInfo info : modInfos) {
                        if (!info.uri.equals(uri)) continue;
                        continue block10;
                    }
                    modInfos.add(new ModInfo(uri, ModIdentifier.getModName(container)));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            try {
                block12: for (BaseMod mod : ModLoader.getLoadedMods()) {
                    try {
                        String uri = ModIdentifier.formatURI(mod.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
                        for (ModInfo info : modInfos) {
                            if (!info.uri.equals(uri)) continue;
                            continue block12;
                        }
                        modInfos.add(new ModInfo(uri, ModIdentifier.formatName(mod.getName())));
                    }
                    catch (Throwable t1) {
                        t1.printStackTrace();
                    }
                }
            }
            catch (Throwable t1) {
                t1.printStackTrace();
            }
        }
    }

    public static String identifyMod(Object object) {
        if (object instanceof aan) {
            object = ((aan)object).a();
        }
        if (object instanceof vd) {
            object = pb.m[((vd)object).d()];
        }
        if (object == null) {
            return null;
        }
        String mod = (String)objectToMod.get(object);
        if (mod != null) {
            return mod;
        }
        mod = ModIdentifier.lookupMod(object);
        if (mod != null) {
            objectToMod.put(object, mod);
            return mod;
        }
        objectToMod.put(object, MINECRAFT);
        return MINECRAFT;
    }

    private static String lookupMod(Object object) {
        String mod = BlockHelperModSupport.getMod(object);
        if (mod != null) {
            return mod;
        }
        try {
            String modFile = ModIdentifier.formatURI(object.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            for (ModInfo modInfo : modInfos) {
                if (!modFile.contains(modInfo.uri)) continue;
                return modInfo.name;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String getModName(ModContainer container) {
        if (container != null) {
            ModMetadata metadata = container.getMetadata();
            if (metadata != null && metadata.name != null) {
                return ModIdentifier.formatName(metadata.name);
            }
            return ModIdentifier.formatName(container.getName());
        }
        return MINECRAFT;
    }

    private static String formatName(String name) {
        return name.replaceFirst("^mod_", "").replaceAll("\u00a7.", "");
    }

    private static String formatURI(URI uri) {
        String uriStr = uri.toString();
        try {
            JarURLConnection connection = (JarURLConnection)uri.toURL().openConnection();
            uriStr = connection.getJarFileURL().toURI().toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            uriStr = URLDecoder.decode(uriStr, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return uriStr;
    }

    private static class ModInfo {
        private final String uri;
        private final String name;

        private ModInfo(String uri, String name) {
            this.uri = uri;
            this.name = name;
        }
    }
}

