/*
 * Decompiled with CFR 0.152.
 */
package de.thexxturboxx.blockhelper.integration;

import de.thexxturboxx.blockhelper.BlockHelperCommonProxy;
import de.thexxturboxx.blockhelper.api.BlockHelperBlockState;
import de.thexxturboxx.blockhelper.api.BlockHelperInfoProvider;
import de.thexxturboxx.blockhelper.api.InfoHolder;
import de.thexxturboxx.blockhelper.i18n.I18n;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class VanillaIntegration
extends BlockHelperInfoProvider {
    @Override
    public void addInformation(BlockHelperBlockState state, InfoHolder info) {
        if (this.isCrop(state.block)) {
            double max_stage = this.getMaxStage(state.block, state.id);
            int grow = (int)((double)state.meta / max_stage * 100.0);
            String toShow = grow >= 100 ? I18n.format("mature", new Object[0]) : grow + "%";
            info.add(I18n.format("growth_state_format", toShow));
        }
        if (state.id == pb.av.bO) {
            info.add(I18n.format("strength_format", state.meta));
        }
        if (state.id == pb.aJ.bO) {
            String leverState = I18n.format(state.meta >= 8 ? "on" : "off", new Object[0]);
            info.add(I18n.format("state_format", leverState));
        }
        if (state.id == pb.bh.bO || state.id == pb.bi.bO) {
            info.add(I18n.format("delay", ((state.meta & 0xC) >> 2) + 1));
        }
    }

    @Override
    public String getName(BlockHelperBlockState state) {
        if (state.block instanceof aei) {
            pb drop = (pb)VanillaIntegration.getDeclaredField(aei.class, state.block, "a");
            return drop.r();
        }
        if (state.id == pb.aa.bO) {
            return I18n.format("piston_head", new Object[0]);
        }
        if (state.id == pb.ac.bO) {
            return I18n.format("moving_piston", new Object[0]);
        }
        if (state.id == pb.ak.bO) {
            aan is = new aan(state.id, 1, state.meta & 0xFFFFFFF7);
            return is.a().d(is);
        }
        if (state.id == pb.bl.bO) {
            switch (state.meta) {
                case 0: {
                    return I18n.format("stone_monster_egg", new Object[0]);
                }
                case 1: {
                    return I18n.format("cobblestone_monster_egg", new Object[0]);
                }
                case 2: {
                    return I18n.format("stone_brick_monster_egg", new Object[0]);
                }
                case 3: {
                    return I18n.format("mossy_stone_brick_monster_egg", new Object[0]);
                }
                case 4: {
                    return I18n.format("cracked_stone_brick_monster_egg", new Object[0]);
                }
                case 5: {
                    return I18n.format("chiseled_stone_brick_monster_egg", new Object[0]);
                }
            }
        }
        if (state.id == pb.bH.bO) {
            return I18n.format("end_portal", new Object[0]);
        }
        if (state.id == pb.bI.bO) {
            return I18n.format("end_portal_frame", new Object[0]);
        }
        return super.getName(state);
    }

    @Override
    public boolean isEnabled() {
        return BlockHelperCommonProxy.vanillaIntegration;
    }

    private double getMaxStage(pb b, int id) {
        try {
            if (VanillaIntegration.iof(b, "flora.FloraCrops")) {
                return 3.0;
            }
            if (b instanceof jx) {
                return 7.0;
            }
            if (b instanceof aei) {
                return 7.0;
            }
            if (b instanceof rr) {
                return 3.0;
            }
            for (Field field : b.getClass().getFields()) {
                if (!VanillaIntegration.containsIgnoreCase(field.getName(), "max") || !VanillaIntegration.containsIgnoreCase(field.getName(), "stage")) continue;
                field.setAccessible(true);
                return field.getInt(pb.m[id]);
            }
            for (Field field : b.getClass().getDeclaredFields()) {
                if (!VanillaIntegration.containsIgnoreCase(field.getName(), "max") || !VanillaIntegration.containsIgnoreCase(field.getName(), "stage")) continue;
                field.setAccessible(true);
                return field.getInt(pb.m[id]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 7.0;
    }

    private boolean isCrop(pb b) {
        boolean crop;
        boolean bl = crop = b instanceof jx || b instanceof rr || b instanceof aei;
        if (!crop) {
            try {
                for (Method method : b.getClass().getDeclaredMethods()) {
                    String name = method.getName();
                    if (name.equals("getGrowthRate")) {
                        return true;
                    }
                    if (!name.equals("getGrowthModifier")) continue;
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return crop;
    }

    private static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int length = searchStr.length();
        if (length == 0) {
            return true;
        }
        for (int i = str.length() - length; i >= 0; --i) {
            if (!str.regionMatches(true, i, searchStr, 0, length)) continue;
            return true;
        }
        return false;
    }
}

