/*
 * Decompiled with CFR 0.152.
 */
package de.thexxturboxx.blockhelper.integration;

import de.thexxturboxx.blockhelper.BlockHelperCommonProxy;
import de.thexxturboxx.blockhelper.api.BlockHelperBlockState;
import de.thexxturboxx.blockhelper.api.BlockHelperInfoProvider;
import de.thexxturboxx.blockhelper.api.InfoHolder;
import de.thexxturboxx.blockhelper.i18n.I18n;
import ic2.api.IEnergyStorage;
import ic2.common.Ic2Items;
import ic2.common.TileEntityElecMachine;
import ic2.common.TileEntityElectricBlock;
import ic2.common.TileEntityMatter;

public class Ic2Integration
extends BlockHelperInfoProvider {
    @Override
    public void addInformation(BlockHelperBlockState state, InfoHolder info) {
        if (Ic2Integration.iof(state.te, "ic2.common.TileEntityElecMachine")) {
            TileEntityElecMachine teem = (TileEntityElecMachine)state.te;
            int energy = teem.energy;
            int maxEnergy = teem.maxEnergy;
            int input = teem.maxInput;
            int newEnergy = Ic2Integration.getRealEnergy(energy, maxEnergy, input);
            if (maxEnergy != 0) {
                info.add(newEnergy + " EU / " + maxEnergy + " EU");
            }
            if (Ic2Integration.iof(state.te, "ic2.common.TileEntityMatter")) {
                info.add(I18n.format("progress_format", ((TileEntityMatter)state.te).getProgressAsString()));
            }
        }
        if (Ic2Integration.iof(state.te, "ic2.api.IEnergyStorage")) {
            IEnergyStorage storage = (IEnergyStorage)state.te;
            if (storage.getCapacity() != 0) {
                info.add(storage.getStored() + " EU / " + storage.getCapacity() + " EU");
            }
        } else if (Ic2Integration.iof(state.te, "ic2.common.TileEntityElectricBlock")) {
            TileEntityElectricBlock teeb = (TileEntityElectricBlock)state.te;
            if (teeb.maxStorage != 0) {
                info.add(teeb.energy + " EU / " + teeb.maxStorage + " EU");
            }
        }
    }

    @Override
    public aan getItemStack(BlockHelperBlockState state) {
        if (Ic2Integration.iof(state.te, "ic2.common.TileEntityCable")) {
            return new aan(yr.e[Ic2Items.copperCableItem.c], 1, state.meta);
        }
        return super.getItemStack(state);
    }

    @Override
    public boolean isEnabled() {
        return BlockHelperCommonProxy.ic2Integration;
    }

    static int getRealEnergy(int energy, int maxEnergy, int input) {
        return Math.min(maxEnergy, maxEnergy * energy / (maxEnergy - input));
    }
}

