/*
 * Decompiled with CFR 0.152.
 */
package de.thexxturboxx.blockhelper.integration;

import buildcraft.api.ILiquidContainer;
import buildcraft.api.IPowerReceptor;
import buildcraft.api.LiquidSlot;
import buildcraft.api.PowerProvider;
import buildcraft.api.liquids.ILiquidTank;
import buildcraft.api.liquids.ITankContainer;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;
import buildcraft.factory.TilePump;
import buildcraft.transport.TileGenericPipe;
import de.thexxturboxx.blockhelper.BlockHelperCommonProxy;
import de.thexxturboxx.blockhelper.api.BlockHelperBlockState;
import de.thexxturboxx.blockhelper.api.BlockHelperInfoProvider;
import de.thexxturboxx.blockhelper.api.InfoHolder;
import de.thexxturboxx.blockhelper.i18n.I18n;
import java.lang.reflect.Method;

public class BuildcraftIntegration
extends BlockHelperInfoProvider {
    @Override
    public void addInformation(BlockHelperBlockState state, InfoHolder info) {
        Method m;
        PowerProvider prov;
        Number maxEnergy;
        Number energyStored;
        if (BuildcraftIntegration.iof(state.te, "buildcraft.energy.TileEngine")) {
            Engine engine = ((TileEngine)state.te).engine;
            if (engine != null) {
                energyStored = (Number)BuildcraftIntegration.getField(Engine.class, engine, "energy");
                maxEnergy = (Number)BuildcraftIntegration.getField(Engine.class, engine, "maxEnergy");
                if (energyStored != null && maxEnergy != null && maxEnergy.doubleValue() != 0.0) {
                    info.add(energyStored.intValue() + " MJ / " + maxEnergy.intValue() + " MJ");
                }
            }
        } else if (BuildcraftIntegration.iof(state.te, "buildcraft.api.IPowerReceptor")) {
            prov = ((IPowerReceptor)state.te).getPowerProvider();
            if (prov != null) {
                energyStored = (Number)BuildcraftIntegration.getField(PowerProvider.class, prov, "energyStored");
                maxEnergy = (Number)BuildcraftIntegration.getField(PowerProvider.class, prov, "maxEnergyStored");
                if (energyStored != null && maxEnergy != null && maxEnergy.doubleValue() != 0.0) {
                    info.add(energyStored.intValue() + " MJ / " + maxEnergy.intValue() + " MJ");
                }
            }
        } else if (BuildcraftIntegration.iof(state.te, "buildcraft.api.power.IPowerReceptor") && (prov = ((buildcraft.api.power.IPowerReceptor)state.te).getPowerProvider()) != null && prov.getMaxEnergyStored() != 0) {
            info.add((int)prov.getEnergyStored() + " MJ / " + prov.getMaxEnergyStored() + " MJ");
        }
        if (BuildcraftIntegration.iof(state.te, "buildcraft.api.ILiquidContainer")) {
            int quantity;
            int capacity;
            ILiquidContainer container = (ILiquidContainer)state.te;
            Method m2 = BuildcraftIntegration.getMethod(ILiquidContainer.class, "getLiquidSlots", new Class[0]);
            boolean flag = false;
            if (m2 != null) {
                try {
                    LiquidSlot[] slots;
                    for (LiquidSlot slot : slots = (LiquidSlot[])m2.invoke((Object)state.te, new Object[0])) {
                        int quantity2 = slot.getLiquidQty();
                        int capacity2 = Math.max(quantity2, slot.getCapacity());
                        if (capacity2 == 0 || quantity2 <= 0) continue;
                        info.add(quantity2 + " mB / " + capacity2 + " mB" + BuildcraftIntegration.formatLiquidName(BuildcraftIntegration.getBcLiquidName(slot)));
                    }
                    flag = true;
                }
                catch (Throwable slots) {
                    // empty catch block
                }
            }
            if (!flag && (capacity = Math.max(quantity = container.getLiquidQuantity(), container.getCapacity())) != 0 && quantity > 0) {
                info.add(quantity + " mB / " + capacity + " mB" + BuildcraftIntegration.formatLiquidName(BuildcraftIntegration.getBcLiquidName(container)));
            }
        } else if (BuildcraftIntegration.iof(state.te, "buildcraft.api.liquids.ITankContainer") && (m = BuildcraftIntegration.getMethod(ITankContainer.class, "getTanks", new Class[0])) != null) {
            try {
                ILiquidTank[] tanks;
                for (ILiquidTank tank : tanks = (ILiquidTank[])m.invoke((Object)state.te, new Object[0])) {
                    LiquidStack stack = tank.getLiquid();
                    int quantity = stack == null ? 0 : stack.amount;
                    int capacity = Math.max(quantity, tank.getCapacity());
                    if (capacity == 0 || quantity <= 0) continue;
                    info.add(quantity + " mB / " + capacity + " mB" + BuildcraftIntegration.formatLiquidName(BuildcraftIntegration.getBcLiquidName(stack)));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (BuildcraftIntegration.iof(state.te, "buildcraft.factory.TilePump")) {
            TilePump pump = (TilePump)state.te;
            info.add(pump.internalLiquid + " mB / 1000 mB" + BuildcraftIntegration.formatLiquidName(BuildcraftIntegration.getBcLiquidName(pump.liquidId)));
        }
    }

    @Override
    public String getMod(BlockHelperBlockState state) {
        if (BuildcraftIntegration.iof(state.te, "buildcraft.transport.TileGenericPipe")) {
            return "BuildCraft";
        }
        return super.getMod(state);
    }

    @Override
    public aan getItemStack(BlockHelperBlockState state) {
        if (BuildcraftIntegration.iof(state.te, "buildcraft.transport.TileGenericPipe")) {
            TileGenericPipe pipe = (TileGenericPipe)state.te;
            if (pipe.pipe != null) {
                return new aan(yr.e[pipe.pipe.itemID], state.te.n);
            }
        }
        return super.getItemStack(state);
    }

    @Override
    public boolean isEnabled() {
        return BlockHelperCommonProxy.bcIntegration;
    }

    public static String formatLiquidName(String liquidName) {
        return liquidName == null || liquidName.trim().isEmpty() ? "" : I18n.format("liquid_format", "", liquidName);
    }

    public static String getBcLiquidName(Object liquid) {
        try {
            LiquidSlot slot = (LiquidSlot)liquid;
            aan is = new aan(slot.getLiquidId(), 1, 0);
            return is.a().d(is);
        }
        catch (Throwable slot) {
            try {
                ILiquidContainer container = (ILiquidContainer)liquid;
                aan is = new aan(container.getLiquidId(), 1, 0);
                return is.a().d(is);
            }
            catch (Throwable container) {
                try {
                    aan is = ((LiquidStack)liquid).asItemStack();
                    return is.a().d(is);
                }
                catch (Throwable is) {
                    try {
                        aan is2 = new aan(((Integer)liquid).intValue(), 1, 0);
                        return is2.a().d(is2);
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                }
            }
        }
    }
}

