/*
 * Decompiled with CFR 0.152.
 */
package de.thexxturboxx.blockhelper.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public final class I18n {
    private static final String PREFIX = "blockhelper.";
    private static final String[] LANGUAGES = new String[]{"en_US", "de_DE"};

    private I18n() {
        throw new UnsupportedOperationException();
    }

    public static void init() {
        for (String lang : LANGUAGES) {
            I18n.loadLanguage(lang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLanguage(String lang) {
        InputStream stream = null;
        InputStreamReader reader = null;
        try {
            stream = I18n.class.getResourceAsStream("/de/thexxturboxx/blockhelper/i18n/" + lang + ".properties");
            if (stream == null) {
                throw new IOException("Couldn't load language file.");
            }
            reader = new InputStreamReader(stream, "UTF-8");
            Properties props = new Properties();
            props.load(reader);
            for (String key : props.stringPropertyNames()) {
                ModLoader.addLocalization((String)key, (String)lang, (String)props.getProperty(key));
            }
        }
        catch (Throwable t) {
            mod_BlockHelper.LOGGER.severe("Error loading language " + lang + ".");
            t.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable props) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable props) {}
            }
        }
    }

    public static String format(String key, Object ... args) {
        return cy.a((String)(PREFIX + key), (Object[])args);
    }

    public static String format(boolean b) {
        return I18n.format(b ? "true" : "false", new Object[0]);
    }
}

