/*
 * Decompiled with CFR 0.152.
 */
package de.thexxturboxx.blockhelper.client;

import de.thexxturboxx.blockhelper.BlockHelperClientProxy;
import de.thexxturboxx.blockhelper.BlockHelperUpdater;
import de.thexxturboxx.blockhelper.MopType;
import de.thexxturboxx.blockhelper.PacketCoder;
import de.thexxturboxx.blockhelper.PacketInfo;
import de.thexxturboxx.blockhelper.api.BlockHelperBlockState;
import de.thexxturboxx.blockhelper.api.BlockHelperModSupport;
import de.thexxturboxx.blockhelper.fix.FixDetector;
import de.thexxturboxx.blockhelper.i18n.I18n;
import de.thexxturboxx.blockhelper.integration.MicroblockIntegration;
import de.thexxturboxx.blockhelper.integration.nei.ModIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class BlockHelperGui {
    public static final int PADDING = 12;
    private static final Random RND = new Random();
    private static final tw RENDER_ITEM = new tw();
    private static BlockHelperGui instance;
    private final List infos = new ArrayList();
    private volatile List packetInfos = new ArrayList();
    private boolean firstTick = true;
    private boolean isHidden = false;

    private BlockHelperGui() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onTickInGame(Minecraft mc) {
        try {
            GL11.glPushMatrix();
            GL11.glScaled((double)BlockHelperClientProxy.size, (double)BlockHelperClientProxy.size, (double)BlockHelperClientProxy.size);
            if (this.firstTick) {
                ModIdentifier.firstTick();
                FixDetector.detectFixes(mc);
                BlockHelperUpdater.notifyUpdater(mc);
                this.firstTick = false;
            }
            this.updateKeyState();
            if (mc.s != null && !mc.w.e() || this.isHidden || mc.A.F && BlockHelperClientProxy.shouldHideFromDebug || !Minecraft.r() || mc.h instanceof ahv && mc.A.y.e) {
                boolean bl = true;
                return bl;
            }
            MopType result = this.getRayTraceResult(mc);
            if (result == MopType.AIR) {
                boolean bl = true;
                return bl;
            }
            pl mop = mc.z;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            xd w = mc.f;
            try {
                if (result == MopType.ENTITY) {
                    PacketCoder.encode(os, new PacketInfo(w.t.g, mop, MopType.ENTITY, mop.g.f));
                } else {
                    PacketCoder.encode(os, new PacketInfo(w.t.g, mop, result));
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            byte[] fieldData = buffer.toByteArray();
            if (w.F) {
                ee packet = new ee();
                packet.a = "BlockHelperInfo";
                packet.c = fieldData;
                packet.b = fieldData.length;
                ModLoader.getMinecraftInstance().q().c((abs)packet);
            } else {
                mod_BlockHelper.INSTANCE.onPacketData(null, "BlockHelperInfoSSP", fieldData);
            }
            switch (result) {
                case BLOCK: {
                    int x = mop.b;
                    int y = mop.c;
                    int z = mop.d;
                    int meta = w.e(x, y, z);
                    int id = w.a(x, y, z);
                    pb b = pb.m[id];
                    kw te = w.b(x, y, z);
                    aan is = BlockHelperModSupport.getItemStack(new BlockHelperBlockState(w, mop, b, te, id, meta));
                    if (is == null) {
                        is = b == null ? new aan(id, 1, meta) : new aan(b, 1, meta);
                    }
                    try {
                        aan microblock = MicroblockIntegration.getMicroblock(w, (yw)mc.h, mop, te);
                        is = microblock == null ? is : microblock;
                    }
                    catch (Throwable microblock) {
                        // empty catch block
                    }
                    String mod = BlockHelperModSupport.getMod(new BlockHelperBlockState(w, mop, b, te, id, meta));
                    mod = mod == null ? ModIdentifier.identifyMod(b) : mod;
                    mod = mod == null ? "Minecraft" : mod;
                    String itemId = is.c + ":" + is.i();
                    if (is.a() == null && b != null) {
                        is = new aan(b.a(meta, RND, id), 1, meta);
                    }
                    if (is.a() == null) {
                        boolean bl = true;
                        return bl;
                    }
                    String name = BlockHelperModSupport.getName(new BlockHelperBlockState(w, mop, b, te, id, meta));
                    String string = name = name == null ? "" : name;
                    if (name.isEmpty()) {
                        try {
                            name = is.a().d(is);
                            if (name.isEmpty()) {
                                throw new IllegalArgumentException();
                            }
                        }
                        catch (Throwable e) {
                            try {
                                aan isNew = new aan(b);
                                name = isNew.a().d(isNew);
                                if (name.isEmpty()) {
                                    throw new IllegalArgumentException();
                                }
                            }
                            catch (Throwable e1) {
                                try {
                                    if (b != null) {
                                        yr it = yr.e[b.a(meta, RND, 0)];
                                        aan stack = new aan(it, 1, mod_BlockHelper.damageDropped(b, meta));
                                        name = it.d(stack);
                                    }
                                    if (name.isEmpty()) {
                                        throw new IllegalArgumentException();
                                    }
                                }
                                catch (Throwable e2) {
                                    name = b != null ? b.r() : I18n.format("please_report", new Object[0]);
                                }
                            }
                        }
                    }
                    String harvest = I18n.format("please_report", new Object[0]);
                    if (b != null) {
                        harvest = b.getHardness(meta) < 0.0f ? I18n.format("unbreakable", new Object[0]) : (b.canHarvestBlock((yw)mc.h, meta) ? I18n.format("harvestable", new Object[0]) : I18n.format("not_harvestable", new Object[0]));
                    }
                    String breakProgression = null;
                    if (mc.g.g > 0.0f) {
                        String progress = gk.d((float)(100.0f * mc.g.g)) + "%";
                        breakProgression = I18n.format("break_progression", progress);
                    }
                    this.infos.clear();
                    this.addInfo(name + (BlockHelperClientProxy.showItemId ? " (" + itemId + ")" : ""));
                    if (BlockHelperClientProxy.showHarvest) {
                        this.addInfo(harvest);
                    }
                    if (BlockHelperClientProxy.showBreakProg) {
                        this.addInfo(breakProgression);
                    }
                    this.addAdditionalInfo(this.packetInfos);
                    if (BlockHelperClientProxy.showMod) {
                        this.addInfo("\u00a79\u00a7o" + mod);
                    }
                    if (BlockHelperClientProxy.showBlock) {
                        int xBox = this.drawBox(mc, 22);
                        int yBox = this.drawInfo(xBox, mc, 22);
                        BlockHelperGui.renderItem(mc, is, xBox + 3, (yBox + 12) / 2 - 8);
                        return true;
                    }
                    int xBox = this.drawBox(mc, 0);
                    this.drawInfo(xBox, mc, 3);
                    return true;
                }
                case ENTITY: {
                    String mod;
                    nn e = mop.g;
                    String nameEntity = aao.b((nn)e);
                    if (e instanceof xf) {
                        nameEntity = "\u00a74" + nameEntity;
                    }
                    mod = (mod = ModIdentifier.identifyMod(e)) == null ? "Minecraft" : mod;
                    this.infos.clear();
                    this.addInfo(nameEntity);
                    this.addAdditionalInfo(this.packetInfos);
                    if (BlockHelperClientProxy.showMod) {
                        this.addInfo("\u00a79\u00a7o" + mod);
                    }
                    int xBox = this.drawBox(mc, 0);
                    this.drawInfo(xBox, mc, 3);
                    return true;
                }
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return true;
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    private void updateKeyState() {
        if (BlockHelperClientProxy.showHide.c()) {
            this.isHidden = !this.isHidden;
        }
    }

    private MopType getRayTraceResult(Minecraft mc) {
        pl mop = mc.z;
        if (mop == null) {
            return MopType.AIR;
        }
        switch (mop.a) {
            case b: {
                return MopType.ENTITY;
            }
            case a: {
                acn b = mc.f.f(mop.b, mop.c, mop.d);
                if (b != null) {
                    return MopType.BLOCK;
                }
                return MopType.AIR;
            }
        }
        return MopType.AIR;
    }

    private void addAdditionalInfo(List info) {
        for (String s : info) {
            this.addInfo("\u00a77" + s);
        }
    }

    private void addInfo(String info) {
        if (info != null && !info.isEmpty()) {
            this.infos.add(info);
        }
    }

    private int drawInfo(int x, Minecraft mc, int leftPadding) {
        int currLine = 12;
        for (String s : this.infos) {
            mc.q.b(s, x + leftPadding, currLine, -1);
            currLine += mc.q.b;
        }
        return currLine;
    }

    private int drawBox(Minecraft mc, int showcaseSize) {
        agd res = new agd(mc.A, mc.d, mc.e);
        int width = (int)((double)res.a() * BlockHelperClientProxy.sizeInv);
        int infoWidth = 0;
        int currLine = 12;
        for (String s : this.infos) {
            infoWidth = Math.max(mc.q.a(s) + 12, infoWidth);
            currLine += mc.q.b;
        }
        currLine = Math.max(currLine, showcaseSize);
        int minusHalf = (width - (infoWidth += showcaseSize)) / 2;
        int plusHalf = (width + infoWidth) / 2;
        int bg = BlockHelperClientProxy.background;
        int grad1 = BlockHelperClientProxy.gradient1;
        int grad2 = BlockHelperClientProxy.gradient2;
        BlockHelperGui.drawGradientRect(minusHalf + 1, 8, minusHalf + 2, currLine + 4, bg, bg);
        BlockHelperGui.drawGradientRect(plusHalf - 2, 8, plusHalf - 1, currLine + 4, bg, bg);
        BlockHelperGui.drawGradientRect(minusHalf + 2, 7, plusHalf - 2, 8, bg, bg);
        BlockHelperGui.drawGradientRect(minusHalf + 2, currLine + 4, plusHalf - 2, currLine + 5, bg, bg);
        BlockHelperGui.drawGradientRect(minusHalf + 3, 9, plusHalf - 3, currLine + 3, bg, bg);
        BlockHelperGui.drawGradientRect(minusHalf + 2, 8, minusHalf + 3, currLine + 4, grad1, grad2);
        BlockHelperGui.drawGradientRect(plusHalf - 3, 8, plusHalf - 2, currLine + 4, grad1, grad2);
        BlockHelperGui.drawGradientRect(minusHalf + 3, 8, plusHalf - 3, 9, grad1, grad1);
        BlockHelperGui.drawGradientRect(minusHalf + 3, currLine + 3, plusHalf - 3, currLine + 4, grad2, grad2);
        return minusHalf + 3;
    }

    public void setData(List packetInfos) {
        this.packetInfos = packetInfos;
    }

    public static BlockHelperGui getInstance() {
        if (instance == null) {
            instance = new BlockHelperGui();
        }
        return instance;
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float zLevel = 0.0f;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        adz tessellator = adz.a;
        tessellator.b();
        tessellator.a(f1, f2, f3, f);
        tessellator.a((double)right, (double)top, (double)zLevel);
        tessellator.a((double)left, (double)top, (double)zLevel);
        tessellator.a(f5, f6, f7, f4);
        tessellator.a((double)left, (double)bottom, (double)zLevel);
        tessellator.a((double)right, (double)bottom, (double)zLevel);
        tessellator.a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void renderItem(Minecraft mc, aan is, int x, int y) {
        try {
            GL11.glPushMatrix();
            GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            tf.b();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)32826);
            RENDER_ITEM.a(mc.q, mc.p, is, x, y);
            GL11.glDisable((int)32826);
            tf.a();
            GL11.glPopMatrix();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

