/*
 * Decompiled with CFR 0.152.
 */
package de.thexxturboxx.blockhelper.api;

import de.thexxturboxx.blockhelper.api.BlockHelperBlockProvider;
import de.thexxturboxx.blockhelper.api.BlockHelperBlockState;
import de.thexxturboxx.blockhelper.api.BlockHelperEntityProvider;
import de.thexxturboxx.blockhelper.api.BlockHelperEntityState;
import de.thexxturboxx.blockhelper.api.BlockHelperItemStackFixer;
import de.thexxturboxx.blockhelper.api.BlockHelperModFixer;
import de.thexxturboxx.blockhelper.api.BlockHelperNameFixer;
import de.thexxturboxx.blockhelper.api.InfoHolder;
import java.util.ArrayList;
import java.util.List;

public final class BlockHelperModSupport {
    private static final List BLOCK_PROVIDERS = new ArrayList();
    private static final List ENTITY_PROVIDERS = new ArrayList();
    private static final List NAME_FIXERS = new ArrayList();
    private static final List IS_FIXERS = new ArrayList();
    private static final List MOD_FIXERS = new ArrayList();

    private BlockHelperModSupport() {
        throw new UnsupportedOperationException();
    }

    public static void registerBlockProvider(BlockHelperBlockProvider provider) {
        BLOCK_PROVIDERS.add(provider);
    }

    public static void registerEntityProvider(BlockHelperEntityProvider provider) {
        ENTITY_PROVIDERS.add(provider);
    }

    public static void registerNameFixer(BlockHelperNameFixer fixer) {
        NAME_FIXERS.add(fixer);
    }

    public static void registerItemStackFixer(BlockHelperItemStackFixer fixer) {
        IS_FIXERS.add(fixer);
    }

    public static void registerModFixer(BlockHelperModFixer fixer) {
        MOD_FIXERS.add(fixer);
    }

    public static void addInfo(BlockHelperBlockState state, InfoHolder info) {
        for (BlockHelperBlockProvider p : BLOCK_PROVIDERS) {
            if (!p.isEnabled()) continue;
            try {
                p.addInformation(state, info);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void addInfo(BlockHelperEntityState state, InfoHolder info) {
        for (BlockHelperEntityProvider p : ENTITY_PROVIDERS) {
            if (!p.isEnabled()) continue;
            try {
                p.addInformation(state, info);
            }
            catch (Throwable throwable) {}
        }
    }

    public static String getName(BlockHelperBlockState state) {
        for (BlockHelperNameFixer f : NAME_FIXERS) {
            try {
                String name = f.getName(state);
                if (name == null || name.isEmpty()) continue;
                return name;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static aan getItemStack(BlockHelperBlockState state) {
        for (BlockHelperItemStackFixer f : IS_FIXERS) {
            try {
                aan stack = f.getItemStack(state);
                if (stack == null) continue;
                return stack;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static String getMod(BlockHelperBlockState state) {
        for (BlockHelperModFixer f : MOD_FIXERS) {
            try {
                String mod = f.getMod(state);
                if (mod == null || mod.isEmpty()) continue;
                return mod;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static String getMod(Object object) {
        for (BlockHelperModFixer f : MOD_FIXERS) {
            try {
                String mod = f.getMod(object);
                if (mod == null || mod.isEmpty()) continue;
                return mod;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }
}

