/*
 * Decompiled with CFR 0.152.
 */
package de.thexxturboxx.blockhelper;

import de.thexxturboxx.blockhelper.i18n.I18n;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import net.minecraft.client.Minecraft;

public class BlockHelperUpdater
implements Runnable {
    private static final String JSON_URL = "https://raw.githubusercontent.com/ThexXTURBOXx/UpdateJSONs/master/block-helper.csv";
    private static boolean isLatestVersion = true;
    private static String latestVersion = "";

    @Override
    public void run() {
        try {
            System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
            latestVersion = BlockHelperUpdater.getLatestModVersion(new URL(JSON_URL).openStream());
            if (!"1.1.1".equals(latestVersion)) {
                mod_BlockHelper.LOGGER.info(I18n.format("newer_version_available", "Block Helper", latestVersion));
            } else {
                mod_BlockHelper.LOGGER.info(I18n.format("newest_version_installed", "Block Helper"));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            mod_BlockHelper.LOGGER.warning(I18n.format("update_check_failed", "Block Helper"));
        }
        isLatestVersion = "1.1.1".equals(latestVersion);
    }

    public static boolean isLatestVersion() {
        return isLatestVersion;
    }

    public static String getLatestVersion() {
        if (latestVersion.isEmpty()) {
            latestVersion = "1.1.1";
        }
        return latestVersion;
    }

    private static String getLatestModVersion(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] split = line.split(",", 2);
                if (!"1.2.5".equals(split[0])) continue;
                String string = split[1];
                return string;
            }
            throw new IllegalArgumentException("Version not found.");
        }
        finally {
            is.close();
            isr.close();
            br.close();
        }
    }

    public static void notifyUpdater(Minecraft mc) {
        if (!BlockHelperUpdater.isLatestVersion()) {
            if (BlockHelperUpdater.getLatestVersion().equals("1.1.1")) {
                mc.h.b(I18n.format("update_check_failed_chat", "Block Helper"));
            } else {
                mc.h.b(I18n.format("newer_version_available_chat", "Block Helper", "1.1.1", BlockHelperUpdater.getLatestVersion()));
            }
        }
    }
}

